<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright ©2013 Fillip Hannisdal AKA Revan/NeoRevan/Belazor 	  # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

if (!in_array($vbulletin->userinfo['userid'], VBSECURITY::$cache['superadmins']))
{
	// user is not a super administrator
	print_stop_message('dbtech_vbsecurity_requires_superadmin');
}

// #############################################################################
if ($_REQUEST['action'] == 'settings')
{
	// #########################################################################
	if ($_REQUEST['category'] == 'vboptions')
	{
		require_once(DIR . '/includes/adminfunctions_language.php');
		require_once(DIR . '/includes/adminfunctions_options.php');
		require_once(DIR . '/includes/functions_misc.php');

		// query settings phrases
		$settingphrase = array();
		$phrases = VBSECURITY::$db->fetchAll('
			SELECT varname, text
			FROM $phrase
			WHERE fieldname = ? AND
				languageid IN(-1, 0, :langId )
			ORDER BY languageid ASC
		', array(
			'vbsettings',
			':langId' => LANGUAGEID
		));
		foreach ($phrases as $phrase)
		{
			$settingphrase[$phrase['varname']] = $phrase['text'];
		}

		$settingscache = array();
		$lastgroup = '';
		$settings = VBSECURITY::$db->fetchAll('
			SELECT setting.*, settinggroup.grouptitle
			FROM $settinggroup AS settinggroup
			LEFT JOIN $setting AS setting USING(grouptitle)
			WHERE (
				setting.varname :settingList
			)
				AND settinggroup.displayorder <> 0
			ORDER BY settinggroup.displayorder, setting.displayorder
		', array(
			':settingList' => VBSECURITY::$db->queryList(array(
				'bbactive',
				'bbclosedreason',
				'banemail',
				'banip',
				'usestrikesystem',
				'dbtech_vbsecurity_allowip',
				'dbtech_vbsecurity_allowip_exclude',
				'dbtech_vbsecurity_breach_closedreason',
				'dbtech_vbsecurity_bannedgroup',
				'dbtech_vbsecurity_bannedreason',
			)),
		));
		foreach ($settings as $setting)
		{
			$settingscache[$setting['grouptitle']][$setting['varname']] = $setting;
			if ($setting['grouptitle'] != $lastgroup)
			{
				$grouptitlecache[$setting['grouptitle']] = $setting['grouptitle'];
				$options[$setting['grouptitle']] = $settingphrase['settinggroup_' . $setting['grouptitle']];
			}
			$lastgroup = $setting['grouptitle'];
		}
		// #####################################################################

		print_cp_header($vbphrase['dbtech_vbsecurity_security_center']);
		print_form_header('vbsecurity', 'security', false, true, 'optionsform', '90%', '', true, 'post" onsubmit="return count_errors()');
		construct_hidden_code('action', 'dooptions');
		print_table_header($vbphrase['dbtech_vbsecurity_settings']);
		foreach ($grouptitlecache AS $dogroup => $group)
		{
			print_column_style_code(array('width:45%', 'width:55%'));

			$bgcounter = 1;

			foreach ($settingscache["$dogroup"] AS $settingid => $setting)
			{
				if (($advanced OR !$setting['advanced']) AND !empty($setting['varname']))
				{
					print_setting_row($setting, $settingphrase);
				}
			}
		}
		print_submit_row($vbphrase['save']);

		?>
		<div id="error_output" style="font: 10pt courier new"></div>
		<script type="text/javascript">
		<!--
		var error_confirmation_phrase = "<?php echo $vbphrase['error_confirmation_phrase']; ?>";
		//-->
		</script>
		<script type="text/javascript" src="../clientscript/vbulletin_settings_validate.js?v=<?php echo SIMPLE_VERSION; ?>"></script>
		<?php
	}

	// #########################################################################
	if ($_REQUEST['category'] == 'usergroups')
	{
		print_cp_header($vbphrase['dbtech_vbsecurity_security_center']);
		print_form_header('vbsecurity', 'security');
		construct_hidden_code('action', 'updateusergroup');
		print_table_header($vbphrase['dbtech_vbsecurity_usergroup_security']);
		print_description_row($vbphrase['dbtech_vbsecurity_usergroup_security_descr']);
		foreach ($vbulletin->usergroupcache as $usergroupid => $usergroup)
		{
			if (!($usergroup['adminpermissions'] & $vbulletin->bf_ugp_adminpermissions['ismoderator']) AND
				!($usergroup['adminpermissions'] & $vbulletin->bf_ugp_adminpermissions['cancontrolpanel'])
			)
			{
				// Not a staffer
				continue;
			}

			print_description_row($usergroup['title'], 0, 2, 'optiontitle');
			print_input_row($vbphrase['password_expiry'], 'usergroup[' . $usergroupid . '][passwordexpires]', $usergroup['passwordexpires']);
			print_input_row($vbphrase['password_history'], 'usergroup[' . $usergroupid . '][passwordhistory]', $usergroup['passwordhistory']);
		}
		print_submit_row($vbphrase['save']);
	}

	/*DBTECH_PRO_START*/
	// #########################################################################
	if ($_REQUEST['category'] == 'passwords')
	{
		foreach($vbulletin->bf_ugp AS $permissiongroup => $fields)
		{
		}

		print_cp_header($vbphrase['dbtech_vbsecurity_security_center']);
		print_form_header('vbsecurity', 'security');
		construct_hidden_code('action', 'updatepassword');
		print_table_header($vbphrase['dbtech_vbsecurity_password_security']);
		print_description_row($vbphrase['dbtech_vbsecurity_password_security_descr']);
		foreach ($vbulletin->usergroupcache as $usergroupid => $usergroup)
		{
			$ug_bitfield = convert_bits_to_array($usergroup['dbtech_vbsecuritypermissions'], $vbulletin->bf_ugp_dbtech_vbsecuritypermissions);

			print_description_row($usergroup['title'], 0, 2, 'optiontitle');
			print_input_row($vbphrase['dbtech_vbsecurity_minimum_password_length'], 		'usergroup[' . $usergroupid . '][dbtech_vbsecurity_passwordlength]', 						$usergroup['dbtech_vbsecurity_passwordlength']);
			print_yes_no_row($vbphrase['dbtech_vbsecurity_password_requires_lowercase'], 	'usergroup[' . $usergroupid . '][dbtech_vbsecuritypermissions][passwordrule_lowercase]', 	$ug_bitfield['passwordrule_lowercase']);
			print_yes_no_row($vbphrase['dbtech_vbsecurity_password_requires_uppercase'], 	'usergroup[' . $usergroupid . '][dbtech_vbsecuritypermissions][passwordrule_uppercase]', 	$ug_bitfield['passwordrule_uppercase']);
			print_yes_no_row($vbphrase['dbtech_vbsecurity_password_requires_numbers'], 		'usergroup[' . $usergroupid . '][dbtech_vbsecuritypermissions][passwordrule_numbers]', 		$ug_bitfield['passwordrule_numbers']);
			print_yes_no_row($vbphrase['dbtech_vbsecurity_password_requires_symbols'], 		'usergroup[' . $usergroupid . '][dbtech_vbsecuritypermissions][passwordrule_symbols]', 		$ug_bitfield['passwordrule_symbols']);
		}
		print_submit_row($vbphrase['save']);
	}

	// #########################################################################
	if ($_REQUEST['category'] == 'admins')
	{
		$administrators = VBSECURITY::$db->fetchAssoc('
			SELECT user.userid, administrator.*, user.username
			FROM $administrator AS administrator
			LEFT JOIN $user AS user ON(user.userid = administrator.userid)
		');

		// #############################################################################

		print_cp_header($vbphrase['dbtech_vbsecurity_security_center']);
		print_form_header('vbsecurity', 'security');
		construct_hidden_code('action', 'updateadmins');
		print_table_header($vbphrase['dbtech_vbsecurity_administrator_security']);
		print_description_row($vbphrase['dbtech_vbsecurity_administrator_security_descr']);
		foreach ($administrators as $userid => $user)
		{
			print_description_row($vbphrase['user'], 0, 2, 'optiontitle');
			print_label_row($vbphrase['user_name'], $user['username']);
			print_input_row($vbphrase['dbtech_vbsecurity_admin_password'], 'admin[' . $userid . '][adminpassword]', ($user['adminpassword'] ? '<password>' : ''));
		}
		// Loop through all records in the administrator table
		print_submit_row($vbphrase['save']);
	}
	/*DBTECH_PRO_END*/
}

// #############################################################################
if ($_REQUEST['action'] == 'recommendations')
{
	VBSECURITY::$cache['recommendations'] = array(
		'installdir' 	=> '',
		'admincpdir' 	=> '',
		'modcpdir' 		=> '',
		'configfile' 	=> '',
		'configsetting' => '',
	);

	// Do install dir recommendation check
	$installdir = @scandir(DIR . '/install');
	foreach ((array)$installdir as $file)
	{
		// Get the extension
		$ext = explode('.', $file);
		$ext = $ext[count($ext) - 1];

		if (!$file)
		{
			// Skip this as it doesn't appear to be a file
			continue;
		}

		if (in_array($file, array('.', '..', '.htaccess', 'functions_installupgrade.php', 'mysql-schema.php')) OR in_array($ext, array('xml', 'html')))
		{
			// Safe files, skip them
			continue;
		}

		// Not an XML file, not the mysql-schema.php
		VBSECURITY::$cache['recommendations']['installdir'] .= '<li>' . $file . '</li>';
	}

	// Check for renamed admin / mod dir
	VBSECURITY::$cache['recommendations']['admincpdir'] 	= ($vbulletin->config['Misc']['admincpdir'] == 'admincp' 	? true : false);
	VBSECURITY::$cache['recommendations']['modcpdir'] 		= ($vbulletin->config['Misc']['modcpdir'] 	== 'modcp' 		? true : false);

	// Check for renamed config.php
	VBSECURITY::$cache['recommendations']['configfile'] 	= file_exists(DIR . '/includes/config.php');

	// Check for setting and config file match
	VBSECURITY::$cache['recommendations']['configsetting'] 	= !file_exists(DIR . '/includes/' . $vbulletin->options['dbtech_vbsecurity_configfile']);

	// #############################################################################
	print_cp_header($vbphrase['dbtech_vbsecurity_security_center']);
	print_form_header('diagnostic', 'doversion');
	print_table_header($vbphrase['dbtech_vbsecurity_recommendations']);
	print_recommendation_row('installdir');
	print_recommendation_row('admincpdir');
	print_recommendation_row('modcpdir');
	//print_recommendation_row('configfile');
	//print_recommendation_row('configsetting');
	print_description_row($vbphrase['dbtech_vbsecurity_server_configuration'], 0, 2, 'optiontitle');
	print_label_row($vbphrase['dbtech_vbsecurity_whm_csf_title'], $vbphrase['dbtech_vbsecurity_whm_csf_descr']);
	//print_label_row($vbphrase['dbtech_vbsecurity_whm_cxs_title'], $vbphrase['dbtech_vbsecurity_whm_cxs_descr']);
	print_description_row($vbphrase['suspect_file_versions'], 0, 2, 'optiontitle');
	print_description_row(construct_phrase($vbphrase['file_versions_explained'], $vbulletin->options['templateversion']));
	print_submit_row($vbphrase['submit'], false);
}

// #############################################################################
if ($_REQUEST['action'] == 'watchers')
{
	foreach ((array)VBSECURITY::$watchers as $category => $watcherList)
	{
		if ($_REQUEST['category'] != $category)
		{
			// Skip this
			continue;
		}

		if (in_array($category, array('usergroup', 'permissions')) AND !VBSECURITY::$isPro)
		{
			// Pro only categories
			continue;
		}

		print_cp_header($vbphrase['dbtech_vbsecurity_security_center']);
		print_form_header('vbsecurity', 'security');
		construct_hidden_code('action', 'updatewatchers');
		construct_hidden_code('category', $category);
		print_table_header($vbphrase['dbtech_vbsecurity_watchers_' . $category]);
		print_description_row($vbphrase['dbtech_vbsecurity_watchers_' . $category . '_descr']);
		foreach ($watcherList as $name)
		{
			print_table_break();
			print_table_header($vbphrase['dbtech_vbsecurity_watcher_' . $name]);

			switch ($category)
			{
				case 'vboptions':
					$phrases['descr'] = $vbphrase['dbtech_vbsecurity_watcher_vboptions_descr'];
					$phrases['good'] = $vbphrase['dbtech_vbsecurity_watcher_vboptions_good'];
					$phrases['bad'] = $vbphrase['dbtech_vbsecurity_watcher_vboptions_bad'];
					break;

				case 'userdata':
					$phrases['descr'] = $vbphrase['dbtech_vbsecurity_watcher_userdata_descr'];
					$phrases['good'] = $vbphrase['dbtech_vbsecurity_watcher_userdata_good'];
					$phrases['bad'] = $vbphrase['dbtech_vbsecurity_watcher_userdata_bad'];
					break;

				case 'usergroup':
					$phrases['descr'] = $vbphrase['dbtech_vbsecurity_watcher_usergroup_descr'];
					$phrases['good'] = $vbphrase['dbtech_vbsecurity_watcher_usergroup_good'];
					$phrases['bad'] = $vbphrase['dbtech_vbsecurity_watcher_usergroup_bad'];
					break;

				default:
					$phrases['descr'] = $vbphrase['dbtech_vbsecurity_watcher_' . $name . '_descr'];
					$phrases['good'] = $vbphrase['dbtech_vbsecurity_watcher_' . $name . '_good'];
					$phrases['bad'] = $vbphrase['dbtech_vbsecurity_watcher_' . $name . '_bad'];
					break;
			}
			print_label_row($phrases['descr'],
				(!VBSECURITY::$cache['watchers'][$name] ?
					'<img src="' . $vbulletin->options['bburl'] . '/dbtech/vbsecurity/images/good.png" style="float: ' . $stylevar['right'] . '; padding-right: 10px; vertical-align: middle;" alt="" />
						' . $phrases['good'] :
					'<img src="' . $vbulletin->options['bburl'] . '/dbtech/vbsecurity/images/bad.png" style="float: ' . $stylevar['right'] . '; padding-right: 10px; vertical-align: middle;" alt="" />
					' . construct_phrase($phrases['bad'], VBSECURITY::$cache['watchers'][$name])
				)
			);

			$actions = array(
				1 => $vbphrase['dbtech_vbsecurity_actions_closeforum'],
				2 => $vbphrase['dbtech_vbsecurity_actions_emailwebmaster'],
			);

			switch ($name)
			{
				case 'configtamper':
				case 'failedlogonadmin':
				case 'failedlogon':
				case 'failedmasslogon':
					// Do nothing
					break;

				default:
					$actions[4] = $vbphrase['dbtech_vbsecurity_actions_banuser'];
					break;
			}

			switch ($name)
			{
				case 'configtamper':
					// Do nothing
					break;

				default:
					$actions[8] = $vbphrase['dbtech_vbsecurity_actions_banip'];
					break;
			}

			print_cells_row(array(
				$vbphrase['dbtech_vbsecurity_rule'],
				$vbphrase['dbtech_vbsecurity_actions']
			), 0, 'thead');
			switch ($name)
			{
				case 'configtamper':
					for ($i = 0; $i < 1; $i++)
					{
						// Shorthand
						$watcher = VBSECURITY::$cache['actions'][$name][$i];

						print_label_row($vbphrase['dbtech_vbsecurity_x_config_tampering_detected'], construct_checkbox_array_row('watchers[' . $name . '][' . $i . '][actions][]', $actions, (int)$watcher['actions']));
					}
					break;

				case 'failedlogonadmin':
					for ($i = 0; $i < 2; $i++)
					{
						// Shorthand
						$watcher = VBSECURITY::$cache['actions'][$name][$i];

						print_label_row(construct_phrase($vbphrase['dbtech_vbsecurity_x_admincp_attempts_y_ips_x_hours'],
							'<input size="4" type="text" class="bginput" name="watchers[' . $name . '][' . $i . '][intrusions]" value="' . (isset($watcher['intrusions']) ? $watcher['intrusions'] : 5) . '" tabindex="1" />',
							'<select class="bginput" name="watchers[' . $name . '][' . $i . '][ipaddresses]" tabindex="1">' . construct_select_options(array(
								0 => $vbphrase['dbtech_vbsecurity_any_ip_address'],
								1 => $vbphrase['dbtech_vbsecurity_same_ip_address'],
							), $watcher['ipaddresses'], false) . '</select>',
							'<input size="4" type="text" class="bginput" name="watchers[' . $name . '][' . $i . '][hours]" value="' . (isset($watcher['hours']) ? $watcher['hours'] : 1) . '" tabindex="1" />'
						), construct_checkbox_array_row('watchers[' . $name . '][' . $i . '][actions][]', $actions, (int)$watcher['actions']));
					}
					break;

				case 'failedlogon':
				case 'failedmasslogon':
					for ($i = 0; $i < 2; $i++)
					{
						// Shorthand
						$watcher = VBSECURITY::$cache['actions'][$name][$i];

						print_label_row(construct_phrase($vbphrase['dbtech_vbsecurity_x_failed_logons_y_ips_x_hours'],
							'<input size="4" type="text" class="bginput" name="watchers[' . $name . '][' . $i . '][intrusions]" value="' . (isset($watcher['intrusions']) ? $watcher['intrusions'] : 5) . '" tabindex="1" />',
							'<select class="bginput" name="watchers[' . $name . '][' . $i . '][ipaddresses]" tabindex="1">' . construct_select_options(array(
								0 => $vbphrase['dbtech_vbsecurity_any_ip_address'],
								1 => $vbphrase['dbtech_vbsecurity_same_ip_address'],
							), $watcher['ipaddresses'], false) . '</select>',
							'<input size="4" type="text" class="bginput" name="watchers[' . $name . '][' . $i . '][hours]" value="' . (isset($watcher['hours']) ? $watcher['hours'] : 1) . '" tabindex="1" />'
						), construct_checkbox_array_row('watchers[' . $name . '][' . $i . '][actions][]', $actions, (int)$watcher['actions']));
					}
					break;

				default:
					for ($i = 0; $i < 2; $i++)
					{
						$watcher = VBSECURITY::$cache['actions'][$name][$i];

						print_label_row(construct_phrase($vbphrase['dbtech_vbsecurity_x_changes_same_user_y_hours'],
							'<input size="4" type="text" class="bginput" name="watchers[' . $name . '][' . $i . '][intrusions]" value="' . (isset($watcher['intrusions']) ? $watcher['intrusions'] : 5) . '" tabindex="1" />',
							'<input size="4" type="text" class="bginput" name="watchers[' . $name . '][' . $i . '][hours]" value="' . (isset($watcher['hours']) ? $watcher['hours'] : 1) . '" tabindex="1" />'
						), construct_checkbox_array_row('watchers[' . $name . '][' . $i . '][actions][]', $actions, (int)$watcher['actions']));
					}
					break;
			}
		}
		print_table_break();
		print_submit_row($vbphrase['save'], false, 2, false, "<input type=\"button\" id=\"resetwatchers\" class=\"button\" value=\"" . str_pad($vbphrase['dbtech_vbphrase_reset_watcher_alerts'], 8, ' ', STR_PAD_BOTH) . "\" tabindex=\"1\" onclick=\"window.location = 'vbsecurity.php?do=security&amp;action=resetwatchers&amp;category=$category'\" />");
	}
}

// #############################################################################
if ($_REQUEST['action'] == 'dooptions')
{
	$vbulletin->input->clean_gpc('p', 'setting', TYPE_ARRAY);

	if (!empty($vbulletin->GPC['setting']))
	{
		require_once(DIR . '/includes/adminfunctions_options.php');
		save_settings($vbulletin->GPC['setting']);
	}

	define('CP_REDIRECT', 'vbsecurity.php?do=security&action=settings&category=vboptions');
	print_stop_message('saved_settings_successfully');
}

// #############################################################################
if ($_POST['action'] == 'updatewatchers')
{
	$vbulletin->input->clean_gpc('p', 'watchers', TYPE_ARRAY);
	$vbulletin->input->clean_gpc('p', 'category', TYPE_STR);

	foreach ($vbulletin->GPC['watchers'] as $name => $rules)
	{
		// Set the new array
		VBSECURITY::$cache['actions'][$name] = $rules;

		foreach ($rules as $ruleid => $settings)
		{
			$bit = 0;
			foreach ($settings['actions'] as $setting)
			{
				// Increment the bit
				$bit += $setting;
			}

			// Set the actions as a bit instead
			VBSECURITY::$cache['actions'][$name][$ruleid]['actions'] = $bit;
		}
	}

	// Store data in the datastore (xD)
	build_datastore('dbtech_vbsecurity_actions', trim(serialize(VBSECURITY::$cache['actions'])), 1);

	define('CP_REDIRECT', 'vbsecurity.php?do=security&action=watchers&category=' . $vbulletin->GPC['category']);
	print_stop_message('dbtech_vbsecurity_x_y', $vbphrase['dbtech_vbsecurity_watchers'], $vbphrase['dbtech_vbsecurity_edited']);
}

// #############################################################################
if ($_REQUEST['action'] == 'resetwatchers')
{
	$vbulletin->input->clean_gpc('r', 'category', TYPE_STR);

	foreach ((array)VBSECURITY::$watchers[$vbulletin->GPC['category']] as $name)
	{
		// Reset this
		VBSECURITY::$cache['watchers'][$name] = '';
	}

	// Store data in the datastore (xD)
	build_datastore('dbtech_vbsecurity_watchers', trim(serialize(VBSECURITY::$cache['watchers'])), 1);

	define('CP_REDIRECT', 'vbsecurity.php?do=security&action=watchers&category=' . $vbulletin->GPC['category']);
	print_stop_message('dbtech_vbsecurity_x_y', $vbphrase['dbtech_vbsecurity_watchers'], $vbphrase['dbtech_vbsecurity_edited']);
}

// #############################################################################
if ($_POST['action'] == 'updateusergroup')
{
	$vbulletin->input->clean_gpc('p', 'usergroup', TYPE_ARRAY);

	foreach ($vbulletin->GPC['usergroup'] as $usergroupid => $usergroup)
	{
		// Update the usergroup with the new data
		VBSECURITY::$db->update('usergroup', $usergroup, 'WHERE usergroupid = ' . $usergroupid);
	}

	// Rebuild UG cache
	build_forum_permissions();

	define('CP_REDIRECT', 'vbsecurity.php?do=security&action=settings&category=usergroups');
	print_stop_message('dbtech_vbsecurity_x_y', $vbphrase['usergroup'], $vbphrase['dbtech_vbsecurity_edited']);
}

/*DBTECH_PRO_START*/
// #############################################################################
if ($_POST['action'] == 'updatepassword')
{
	$vbulletin->input->clean_gpc('p', 'usergroup', TYPE_ARRAY);

	require_once(DIR . '/includes/functions_misc.php');
	foreach ($vbulletin->GPC['usergroup'] as $usergroupid => $usergroup)
	{
		// Sort out these things
		$usergroup['dbtech_vbsecuritypermissions'] = convert_array_to_bits($usergroup['dbtech_vbsecuritypermissions'], $vbulletin->bf_ugp_dbtech_vbsecuritypermissions, 1);

		// Update the usergroup with the new data
		VBSECURITY::$db->update('usergroup', $usergroup, 'WHERE usergroupid = ' . $usergroupid);
	}

	// Rebuild UG cache
	build_forum_permissions();

	define('CP_REDIRECT', 'vbsecurity.php?do=security&action=settings&category=passwords');
	print_stop_message('dbtech_vbsecurity_x_y', $vbphrase['password'], $vbphrase['dbtech_vbsecurity_edited']);
}

// #############################################################################
if ($_POST['action'] == 'updateadmins')
{
	$vbulletin->input->clean_gpc('p', 'admin', TYPE_ARRAY);

	foreach ($vbulletin->GPC['admin'] as $userid => $admin)
	{
		if ($admin['adminpassword'] == '<password>')
		{
			// Use existing password
			continue;
		}

		if ($admin['adminpassword'])
		{
			// Override the admin password
			$admin['adminpassword'] = md5(md5($admin['adminpassword']) . VBSECURITY::$db->fetchOne('SELECT salt FROM $user WHERE userid = ?', array($userid)));
		}

		// Update the administrator with the new data
		VBSECURITY::$db->update('administrator', $admin, 'WHERE userid = ' . $userid);
	}

	define('CP_REDIRECT', 'vbsecurity.php?do=security&action=settings&category=admins');
	print_stop_message('dbtech_vbsecurity_x_y', $vbphrase['administrator'], $vbphrase['dbtech_vbsecurity_edited']);
}
/*DBTECH_PRO_END*/

print_cp_footer();